<?php
session_start();
require_once '../includes/config.php';

// Generate report number
$datePrefix = date("Ymd");
$stmt = $pdo->prepare("SELECT COUNT(*) AS count FROM incident_reports WHERE report_number LIKE ?");
$stmt->execute(["REP{$datePrefix}%"]);
$countToday = (int)$stmt->fetchColumn() + 1;
$reportNumber = "REP{$datePrefix}" . str_pad($countToday, 4, '0', STR_PAD_LEFT);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Submit Incident Report</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
  <div class="card shadow">
    <div class="card-header bg-primary text-white">
      <h4 class="mb-0">Incident Report Form</h4>
    </div>
    <div class="card-body">
      <form action="submit_officer_incident.php" method="POST" enctype="multipart/form-data">
  <div class="mb-3">
    <label>Report Number</label>
    <input type="text" name="report_number" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Incident Date</label>
    <input type="date" name="incident_date" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Incident Time</label>
    <input type="time" name="incident_time" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Informant Name</label>
    <input type="text" name="informant_name" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Contact Number</label>
    <input type="text" name="contact_no" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Subject</label>
    <input type="text" name="subject" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Recording Officer</label>
    <input type="text" name="recording_officer" class="form-control" required>
  </div>

  <div class="mb-3">
    <label>Photos (Multiple)</label>
    <input type="file" name="photos[]" class="form-control" multiple accept="image/*">
  </div>

  <div class="mb-3">
    <label>Videos (Multiple)</label>
    <input type="file" name="videos[]" class="form-control" multiple accept="video/*">
  </div>

  <button type="submit" class="btn btn-primary">Submit Incident</button>
</form>

    </div>
  </div>
</div>
</body>
</html>
